

#ifndef _HOARD_H_
#define _HOARD_H_

#include <silib/splat.hpp>
#if !defined(PLAT_WINDOWS32)
  #define DLLFUNC
#else
  #include <windows.h>
  #define DLLFUNC    WINAPI
#endif

#if defined (SINGLE_THREADED)
#define hmalloc malloc
#define hcalloc calloc
#define hfree   free
#define hrealloc realloc
#define hallocator allocator

#else

//
//DEBUG_NEW screws us up as it stops us from using the placement new operator
#ifdef new
#undef new
#endif

#include <new>
#include <cstdlib>
#ifdef __sun
#include <limits.h>
#endif // __sun

// SILIB now uses Hoard in a DLL - for more info, see "hoard.cpp"
// To facilitate this, hmalloc, hfree & hrealloc are now function pointers that point to initializing functions _hmalloc, _hfree & _hrealloc
// Hence, when hmalloc is first called, _hmalloc tries to load the Hoard DLL, get the function address and set hmalloc to that function
// If it fails to get the function address from the DLL, then use the default implementation (i.e. malloc)  
typedef void * (DLLFUNC * pMallocFunc) (size_t);
typedef void (DLLFUNC * pFreeFunc) (void *);
typedef void * (DLLFUNC * pReallocFunc) (void *, size_t);

extern pMallocFunc hmalloc;
extern pFreeFunc hfree;
extern pReallocFunc hrealloc;

#if !defined(__SUNPRO_CC) && !defined(PLAT_AIX)
//
// STL allocator equivalents using hoard
//
#pragma warning (disable:4786) // C4786 'identifier' : identifier was truncated to 'number' characters in the debug information
template<class T>
class hallocator 
{
public:
	typedef size_t      size_type;
	typedef ptrdiff_t   difference_type;
	typedef T         * pointer;
	typedef const T   * const_pointer;
	typedef T         & reference;
	typedef const T   & const_reference;
	typedef T           value_type;

#if defined(__linux__) || (_MSC_VER >= 1300)

    hallocator()
    {
    }

    hallocator(const hallocator &)
    {
    }


    template<class _Tp1> 
        hallocator( const hallocator<_Tp1> &) {}

    template<class _Tp1> struct rebind {
        typedef hallocator<_Tp1> other;
    };

#endif // __linux__



	pointer address ( reference r ) const {
        return (&r);
    }
	const_pointer address ( const_reference r ) const {
        return (&r); 
    }
#ifdef __sun
    void *allocate ( size_type _size, const void * hint = 0 ) {
#else
    pointer allocate ( size_type _size, const void * hint = 0 ) {
#endif // __sun
        //TODO: if someone is bored then figuring out how to incorporate the hint seems like a fun task =)
#if defined (__SUNPRO_CC)
		return hmalloc ( _size );
#elif defined (_MSC_VER) || defined (__GNUC__)
		return (pointer) hmalloc ( sizeof(value_type) * _size );
#else
        #error "check your compilers STL allocator implementation"
#endif
    }
	void deallocate ( void * ptr, size_type ) {
        hfree (ptr); 
    }
	void construct (pointer _ptr, const T& _t) {
        new ((void*)_ptr) T(_t); 
    }
    void destroy ( pointer ptr ) {
        (ptr)->~T();
    }

	size_type max_size() const {
        //2Gig worth sounds good
        size_type twogigabytes = 2147483648;
        return size_type (twogigabytes / sizeof(T));
    }
#ifdef __sun
    size_type max_size (size_type size) const
    {
        return 1 > UINT_MAX/size ? size_type(1) : size_type(UINT_MAX/size);
    }
#endif // __sun
    //seems this is a hack needed by MSVC
	char  *_Charalloc ( size_type _size ) {
        return (char*) hmalloc ( sizeof(value_type) * _size );
    }
};
template<class T, class U> inline
bool operator== ( const hallocator<T>&, const hallocator<U>& ) {
    return true; 
}
template<class T, class U> inline
bool operator!= ( const hallocator<T>&, const hallocator<U>& ) {
    return false; 
}
template<> class hallocator<void> {
public:
	typedef void    T;
	typedef T       *pointer;
	typedef const T *const_pointer;
	typedef T       value_type;
};

#else
#define hallocator allocator
#endif
    
#endif
#endif


