///-*-C++-*-//////////////////////////////////////////////////////////////////
//
// Hoard: A Fast, Scalable, and Memory-Efficient Allocator
//        for Shared-Memory Multiprocessors
// Contact author: Emery Berger, http://www.cs.utexas.edu/users/emery
//
// Copyright (c) 1998-2000, The University of Texas at Austin.
//
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as
// published by the Free Software Foundation, http://www.fsf.org.
//
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
//////////////////////////////////////////////////////////////////////////////

#include "memstat.h"

#include <assert.h>
#include <iostream.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>


void mergelogs (int nlogs,
		FILE ** f,
		FILE * output)
{
  int * eof = new int[nlogs];
  int * length = new int[nlogs];
  MemoryRequest * m = new MemoryRequest[nlogs];

  int neofs = 0;
  int totallength = 0;

  // Read in the first line of each.
  for (int i = 0; i < nlogs; i++) {
    fread (&length[i], sizeof(int), 1, f[i]);
    if (length[i] == 0) {
      eof[i] = 1;
      neofs++;
    } else {
      eof[i] = 0;
      fread (&m[i], sizeof(MemoryRequest), 1, f[i]);
    }
    totallength += length[i];
  }

  fwrite (&totallength, sizeof(int), 1, output);

  while (neofs < nlogs) {

    printf (".");

    // Find out which files are finished.
    for (int i = 0; i < nlogs; i++) {
      if (!eof[i] && feof(f[i])) {
	eof[i] = 1;
	neofs++;
      }
    }

    if (neofs < nlogs) {

      // Find the least element.
      MemoryRequest least;
      int leastElement = -1;
      for (int i = 0; i < nlogs; i++) {
	if (!eof[i]) {
	  if (m[i] < least) {
	  if (m[i] == least) {
	    if ((m[i].getType() == MemoryRequest::MALLOC_OP)
		|| (m[i].getType() == MemoryRequest::REALLOC_OP)
		|| (m[i].getType() == MemoryRequest::ALLOCATE_OP)) {
	      least = m[i];
	      leastElement = i;
	    }
	  } else {
	    least = m[i];
	    leastElement = i;
	  }
	  }
	}
      }
      assert (leastElement > -1);
      
      fwrite (&least, sizeof(MemoryRequest), 1, output);

      // Read one more element.
      fread (&m[leastElement], sizeof(MemoryRequest), 1, f[leastElement]);
    }
  }
}


int main ()
{
  FILE ** f;

  int i;

  int from = 0;
  int to = 127;

  // nlogs = the number of logs.
  int nlogs = to - from + 1;

  f = new (FILE *)[nlogs];

  //
  // Open all the files.
  //

  // Open the logs.
  for (i = from; i <= to; i++) {
    char fname[255];
    sprintf (fname, "log%d", i);
    f[i] = fopen (fname, "r");
  }

  // Open the output log.
  FILE * output = fopen ("output", "w+");

  // Process them.
  mergelogs (nlogs, f, output);

  // Close all the files.
  for (i = from; i <= to; i++) {
    fclose (f[i]);
  }
  fclose (output);
}





